# whisperings 'home website' http://www.solopianoradio.com
# whisperings 'flash stream' http://player.pianostream.com/player/player.swf
# whisperings 'no flash stream' http://www.solopianoradio.com/noflash.htm
# whisperings 'live in browser' http://pianosolo.streamguys.net/live.m3u

ICON = 'wspr.jpg'
ART = 'whisperings-art.jpg'
PIANO_HOME = 'http://www.solopianoradio.com'

########################
def Start():
    
    Plugin.AddPrefixHandler('/music/Piano', MainMenu, 'Piano', ICON)
    
    ObjectContainer.title1 = 'Whisperings'
    ObjectContainer.art = R(ART)    

##########################


@handler('/music/Piano', 'Piano')

def MainMenu():
    oc = ObjectContainer()

    playlist = HTTP.Request('http://pianosolo.streamguys.net/live.m3u').content
    for track in playlist.splitlines():
        oc.add(CreateTrackObject(url=track, title=track, container=Container.MP3, audio_codec=AudioCodec.MP3))

    return oc

#########################

def CreateTrackObject(url, title, container, audio_codec, include_container=False):
	track_object = TrackObject(
		key = Callback(CreateTrackObject, url=url, title=title, container=container, audio_codec=audio_codec, include_container=True),
		rating_key = url,
		title = title,
		items = [
			MediaObject(
				parts = [
					PartObject(key=url)
				],
				container = container,
				audio_codec = audio_codec,
				audio_channels = 2
			)
		]
	)

	if include_container:
		return ObjectContainer(objects=[track_object])
	else:
		return track_object

